/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.network.SmelteryTankUpdatePacket;

public class SmelteryTank<T extends MantleBlockEntity>
extends SnapshotParticipant<FluidSnapshot>
implements SlottedStorage<FluidVariant> {
    private final T parent;
    private List<FluidStack> fluids = Lists.newArrayList();
    private long capacity = 0L;
    private long contained = 0L;
    private static final String TAG_FLUIDS = "fluids";
    private static final String TAG_CAPACITY = "capacity";

    public SmelteryTank(T parent) {
        this.parent = parent;
    }

    public void syncFluids() {
        class_1937 world = this.parent.method_10997();
        if (world != null && !world.field_9236) {
            class_2338 pos = this.parent.method_11016();
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new SmelteryTankUpdatePacket(pos, this.fluids), (class_1936)world, pos);
        }
    }

    public long getRemainingSpace() {
        if (this.contained >= this.capacity) {
            return 0L;
        }
        return this.capacity - this.contained;
    }

    public int getSlotCount() {
        if (this.contained < this.capacity) {
            return this.fluids.size() + 1;
        }
        return this.fluids.size();
    }

    public SingleSlotStorage<FluidVariant> getSlot(int slot) {
        return new FluidStackSlot(this.getFluidInTank(slot), slot);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public long getTankCapacity(int tank) {
        if (tank < 0) {
            return 0L;
        }
        long remaining = this.capacity - this.contained;
        if (tank == this.fluids.size()) {
            return remaining;
        }
        return this.fluids.get(tank).getAmount() + remaining;
    }

    public void moveFluidToBottom(int index) {
        if (index < this.fluids.size()) {
            FluidStack fluid = this.fluids.get(index);
            this.fluids.remove(index);
            this.fluids.add(0, fluid);
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, FluidStack.EMPTY);
        }
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.contained >= this.capacity || maxAmount <= 0L || resource.isBlank()) {
            return 0L;
        }
        long usable = Math.min(this.capacity - this.contained, maxAmount);
        if (usable <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        this.contained += usable;
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            fluid.grow(usable);
            transaction.addOuterCloseCallback(result -> {
                if (result.wasCommitted()) {
                    ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
                }
            });
            return usable;
        }
        FluidStack fluid = new FluidStack(resource, usable);
        this.fluids.add(fluid);
        transaction.addOuterCloseCallback(result -> {
            if (result.wasCommitted()) {
                ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ADDED, fluid);
            }
        });
        return usable;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        ListIterator<FluidStack> iter = this.fluids.listIterator();
        while (iter.hasNext()) {
            FluidStack fluid = iter.next();
            if (!fluid.isFluidEqual(resource)) continue;
            long drainable = Math.min(maxAmount, fluid.getAmount());
            FluidStack ret = fluid.copy();
            ret.setAmount(drainable);
            this.updateSnapshots(transaction);
            fluid.shrink(drainable);
            this.contained -= drainable;
            if (fluid.getAmount() <= 0L) {
                iter.remove();
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
                    }
                });
            } else {
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
                    }
                });
            }
            return drainable;
        }
        return 0L;
    }

    public void setFluids(List<FluidStack> fluids) {
        FluidStack oldFirst = this.getFluidInTank(0);
        this.fluids.clear();
        this.fluids.addAll(fluids);
        this.contained = fluids.stream().mapToLong(FluidStack::getAmount).reduce(0L, Long::sum);
        FluidStack newFirst = this.getFluidInTank(0);
        if (!oldFirst.isFluidEqual(newFirst)) {
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ORDER_CHANGED, newFirst);
        }
    }

    public class_2487 write(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (FluidStack liquid : this.fluids) {
            class_2487 fluidTag = new class_2487();
            liquid.writeToNBT(fluidTag);
            list.add((Object)fluidTag);
        }
        nbt.method_10566(TAG_FLUIDS, (class_2520)list);
        nbt.method_10544(TAG_CAPACITY, this.capacity);
        return nbt;
    }

    public void read(class_2487 tag) {
        class_2499 list = tag.method_10554(TAG_FLUIDS, 10);
        this.fluids.clear();
        this.contained = 0L;
        for (int i = 0; i < list.size(); ++i) {
            class_2487 fluidTag = list.method_10602(i);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((class_2487)fluidTag);
            if (fluid.isEmpty()) continue;
            this.fluids.add(fluid);
            this.contained += fluid.getAmount();
        }
        this.capacity = tag.method_10537(TAG_CAPACITY);
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return this.getSlots().iterator();
    }

    protected FluidSnapshot createSnapshot() {
        ArrayList<FluidStack> cachedFluids = new ArrayList<FluidStack>();
        for (int i = 0; i < this.fluids.size(); ++i) {
            cachedFluids.add(i, this.fluids.get(i).copy());
        }
        return new FluidSnapshot(this.contained, cachedFluids);
    }

    protected void readSnapshot(FluidSnapshot snapshot) {
        this.fluids = snapshot.fluids();
        this.contained = snapshot.contained();
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getContained() {
        return this.contained;
    }

    public class FluidStackSlot
    extends SnapshotParticipant<FluidSnapshot>
    implements SingleSlotStorage<FluidVariant> {
        private FluidStack fluid;
        private final int slot;

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (SmelteryTank.this.contained >= SmelteryTank.this.capacity || maxAmount <= 0L || resource.isBlank()) {
                return 0L;
            }
            long usable = Math.min(SmelteryTank.this.capacity - SmelteryTank.this.contained, maxAmount);
            if (usable <= 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            SmelteryTank.this.contained += usable;
            if (this.fluid.isFluidEqual(resource)) {
                this.fluid.grow(usable);
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        ((ISmelteryTankHandler)SmelteryTank.this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, this.fluid);
                    }
                });
                return usable;
            }
            FluidStack fluid = new FluidStack(resource, usable);
            SmelteryTank.this.fluids.add(fluid);
            transaction.addOuterCloseCallback(result -> {
                if (result.wasCommitted()) {
                    ((ISmelteryTankHandler)SmelteryTank.this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ADDED, fluid);
                }
            });
            return usable;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (this.fluid.isFluidEqual(resource)) {
                long drainable = Math.min(maxAmount, this.fluid.getAmount());
                this.updateSnapshots(transaction);
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasAborted()) {
                        return;
                    }
                    this.fluid.shrink(drainable);
                    SmelteryTank.this.getFluidInTank(this.slot).shrink(drainable);
                    SmelteryTank.this.contained -= drainable;
                    if (this.fluid.getAmount() <= 0L) {
                        SmelteryTank.this.fluids.remove(this.slot);
                        ((ISmelteryTankHandler)SmelteryTank.this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, this.fluid);
                    } else {
                        ((ISmelteryTankHandler)SmelteryTank.this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, this.fluid);
                    }
                });
                return drainable;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.fluid.getType().isBlank();
        }

        public FluidVariant getResource() {
            return this.fluid.getType();
        }

        public long getAmount() {
            return this.fluid.getAmount();
        }

        public long getCapacity() {
            return SmelteryTank.this.getTankCapacity(this.slot);
        }

        protected FluidSnapshot createSnapshot() {
            return SmelteryTank.this.createSnapshot();
        }

        protected void readSnapshot(FluidSnapshot snapshot) {
            SmelteryTank.this.readSnapshot(snapshot);
        }

        public FluidStackSlot(FluidStack fluid, int slot) {
            this.fluid = fluid;
            this.slot = slot;
        }
    }

    public record FluidSnapshot(long contained, List<FluidStack> fluids) {
    }
}

